@extends(activeTemplate() .'layouts.master')

@section('content')


    @include(activeTemplate().'partials.front_br')

    <section class="about-area gradient-overlay">
        <div class="about-content mid-bg-gray wow fadeInUp" data-wow-delay="0.4s">
            <div class="about-content-inner-2 cl-white">
                <div class="section-title mb-10">

                    <h2>@lang($about->value->title)</h2>
                </div>

                <p>@php echo $about->value->detail;  @endphp</p>

            </div>
        </div>
        <div class="about-left wow fadeInUp" data-wow-delay="0.4s" style="background: url({{ get_image(config('constants.frontend.'. $about->key .'.path') .'/'. $about->value->image) }}) no-repeat center / cover;">
            <div class="left-img-wrap">

            </div>
        </div>
    </section>



    <section class="team-area section-padding-2 blue-bg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-6 centered wow fadeInUp" data-wow-delay="0.3s">
                    <div class="section-title cl-white">
                        <h4>@lang($team_title->value->subtitle)</h4>
                        <h2>@lang($team_title->value->title)</h2>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">

                @foreach($teams as $team)
                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 wow fadeInUp" data-wow-delay="0.4s">
                    <div class="single-team-4">
                        <img src="{{ get_image(config('constants.frontend.team.path') .'/'. $team->value->image) }}" alt="">
                        <div class="team-content">
                            <h4>@lang($team->value->name)</h4>
                            <p>@lang($team->value->designation)</p>

                        </div>
                    </div>
                </div>
                    @endforeach

            </div>
        </div>
    </section>



    <section class="review-area section-padding gradient-overlay">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-9 col-lg-9 col-md-12 col-sm-12 wow fadeInUp" data-wow-delay="0.4s">
                    <div class="section-title cl-white">
                        <h2>@lang($testimonial_title->value->title)</h2>
                        <p>@lang($testimonial_title->value->subtitle)</p>
                    </div>
                    <div class="testimonials owl-carousel">
                        @foreach($testimonial as $data)
                            <div class="single-review">
                                <div class="reviewer-thumb">
                                    <img src="{{ get_image(config('constants.frontend.testimonial.path') .'/'. $data->value->image) }}" alt="">
                                    <h3>@lang($data->value->author)</h3>
                                    <span>@lang($data->value->designation)</span>
                                </div>
                                <p>@lang($data->value->quote)</p>
                            </div>

                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>


@endsection


