@extends(activeTemplate() .'layouts.app')

@section('content')

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="table-responsive table-responsive">
                    <table class="table align-items-center table-light">
                        <thead>
                        <tr>
                            <th scope="col">@lang('Sl')</th>
                            <th scope="col">@lang('Amount') </th>
                            <th scope="col">@lang('Trx') </th>
                            <th scope="col">@lang('Detail') </th>

                            <th scope="col">@lang('Date') </th>
                        </tr>
                        </thead>


                        <tbody class="list">
                        @forelse($logs as $key=>$data)
                            <tr>
                                <td>{{$logs->firstItem()+$key}}</td>
                                <td>{{$general->cur_sym}}{{formatter_money($data->amount)}}</td>
                                <td>{{$data->trx}}</td>
                                <td>{{$data->title}}</td>

                                <td>{{$data->created_at != ''? date('d/m/y  g:i A',strtotime($data->created_at)): __('Not Assign')}}</td>
                            </tr>
                        @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ $empty_message }}</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="card-footer py-4">
                    <nav aria-label="...">
                        {{$logs->links()}}
                    </nav>
                </div>
            </div>
        </div>
    </div>




@endsection
