
@extends(activeTemplate() .'layouts.app')



@section('content')

    <div class="row">
        @foreach($plans as $data)

            <div class="col-xl-4 col-lg-6 col-md-4 col-sm-6">
                <div class="pricingTable">
                    <div class="pricingTable-header">
                        <h3 class="title">@lang($data->name)</h3>
                    </div>
                    <div class="price-value">
                        <span class="currency">{{$general->cur_sym}}</span>
                        <span class="amount">{{formatter_money($data->amount)}}</span>
                    </div>
                    <div class="price-body text-center">
                        <ul class="margin-bottom-30">
                            <li>
                                <strong>  @lang('Business Volume (BV)') : {{formatter_money($data->bv)}}</strong> <button type="button" class="float-right" data-toggle="modal" data-target="#exampleModal" title=""><i class="fa fa-question"></i></button>
                            </li>
                            <li>
                                <strong>  @lang('Referral Commission') : {{$general->cur_sym}} {{formatter_money($data->ref_com)}}</strong> <button class="float-right" type="button" data-toggle="modal" data-target="#exampleModal2" title=""><i class="fa fa-question"></i></button>
                            </li>
                            @if($data->com_to_tree > 0)
                                <li>
                                    <strong>  @lang('Commission to tree') : {{$general->cur_sym}} {{formatter_money($data->com_to_tree)}}</strong> <button  class="float-right" type="button" data-toggle="modal" data-target="#exampleModal3" title=""><i class="fa fa-question"></i></button>
                                       </li>
                            @endif

                        </ul>
                    </div>

                    <div class="pricingTable-signup">

                        @if(Auth::user()->plan_id != $data->id)
                            <a href="#confBuyModal{{$data->id}}" data-toggle="modal">@lang('Subscribe Now')</a>
                        @else

                            <a   data-toggle="modal">@lang('Already purchase')</a>
                        @endif

                    </div>
                </div>
            </div>


            <div class="modal fade" id="confBuyModal{{$data->id}}" tabindex="-1" role="dialog"
                 aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel"> @lang('Confirm Purchase '.$data->name)?</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                        aria-hidden="true">×</span></button>
                        </div>
                        <div class="modal-body">
                            <h5 class="text-danger text-center">{{formatter_money($data->amount)}} {{$general->cur_text}} @lang('will subtract from your balance')</h5>
                        </div>
                        <form method="post" action="{{route('user.plan.purchase')}}">
                            @csrf
                            <div class="modal-footer">
                                <button type="submit" name="plan_id" value="{{$data->id}}"
                                        class="btn btn-primary bold uppercase"><i
                                            class="fa fa-send"></i> @lang('Subscribe')</button>
                                <button type="button" class="btn btn-danger" data-dismiss="modal"><i
                                            class="fa fa-times"></i> @lang('Close')</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endforeach
    </div>


    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang("Business Volume (BV) info")</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                 <h5>   <span class="text-danger">@lang('When someone from your below tree subscribe this plan, You will get this Business Volume  which will be used for matching bonus').</span>
                 </h5>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" data-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('Referral Commission info')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                  <h5>  <span class=" text-danger">@lang('When Your Direct-Referred/Sponsored  User Subscribe in') <b> @lang('ANY PLAN') </b>, @lang('You will get this amount').</span>
                    <br>
                    <br>
                    <span class="text-success"> @lang('This is the reason You should Choose a Plan With Bigger Referral Commission').</span> </h5>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" data-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>



    <div class="modal fade" id="exampleModal3" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('Commission to tree info')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                   <h5 class=" text-danger">@lang('When someone from your below tree subscribe this plan, You will get this amount as Tree Commission'). </h5>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" data-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>


@endsection


@push('style')

@endpush



