@extends('admin.layouts.app')

@section('panel')



    <div class="row justify-content-center">

        <div class="col-md-12">
            <div class="card mt-3">
                <div class="card-header bg-success">
                    <h4 class="card-title font-weight-normal">Matching Bonus</h4>
                </div>
                <form action="{{route('admin.matching-bonus.update')}}" method="post">
                    <div class="card-body">

                        @csrf
                        <div class="row justify-content-between mb-5">


                            <div class="col-md-4">
                                <div class="input-group custom-height">

                                    <input type="text" class="form-control" value="{{$general->total_bv}}"
                                           name="total_bv" id="#" aria-describedby="#" required="">
                                    <div class="input-group-append">
                                        <span class="input-group-text" id="#">BV</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-1">
                                <h2 class="text-center">=</h2>
                            </div>


                            <div class="col-md-3">
                                <div class="input-group custom-height">

                                    <input type="text" class="form-control" name="bv_price"
                                           value="{{$general->bv_price}}" aria-describedby="#" required="">
                                    <div class="input-group-append">
                                        <span class="input-group-text" id="#">{{$general->cur_text}}</span>
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-4">


                                <div class="input-group mb-3 custom-height">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">MAX</span>
                                    </div>
                                    <input type="text" class="form-control" value="{{$general->max_bv}}" name="max_bv"
                                           aria-label="Amount (to the nearest dollar)">
                                    <div class="input-group-append">
                                        <span class="input-group-text">BV</span>
                                    </div>
                                </div>


                            </div>
                        </div>


                        <div class="row">

                            <div class="col-lg-4">

                                <label>Carry/ Flush</label>
                                <select class="form-control form-control-lg" name="cary_flash" required>
                                    <option value="0">Carry (Cut Only Paid BV)</option>
                                    <option value="1">Flush (Cut Weak Leg Value)</option>
                                    <option value="2">Flush (Cut All BV and reset to 0)</option>
                                </select>


                            </div>


                            <div class="form-group col-md-4">
                                <label>Matching Bonus Time</label>
                                <select name="matching_bonus_time" class="form-control form-control-lg">
                                    <option value="daily">Daily</option>
                                    <option value="weekly">Weekly</option>
                                    <option value="monthly">Monthly</option>
                                </select>
                            </div>

                            <div class="form-group col-md-4" id="daily_time" style="display:none;">
                                <label>Daily Time</label>
                                <select name="daily_time" class="form-control form-control-lg">
                                    <option value="1">01:00</option>
                                    <option value="2">02:00</option>
                                    <option value="3">03:00</option>
                                    <option value="4">04:00</option>
                                    <option value="5">05:00</option>
                                    <option value="6">06:00</option>
                                    <option value="7">07:00</option>
                                    <option value="8">08:00</option>
                                    <option value="9">09:00</option>
                                    <option value="10">10:00</option>
                                    <option value="11">11:00</option>
                                    <option value="12">12:00</option>
                                    <option value="13">13:00</option>
                                    <option value="14">14:00</option>
                                    <option value="15">15:00</option>
                                    <option value="16">16:00</option>
                                    <option value="17">17:00</option>
                                    <option value="18">18:00</option>
                                    <option value="19">19:00</option>
                                    <option value="20">20:00</option>
                                    <option value="21">21:00</option>
                                    <option value="22">22:00</option>
                                    <option value="23">23:00</option>
                                    <option value="24">24:00</option>
                                </select>
                            </div>



                            <div class="form-group col-md-4" id="weekly_time" style="display:none;">
                                <label>Weekly Time</label>
                                <select name="weekly_time" class="form-control form-control-lg">
                                    <option value="sat">Saturday</option>
                                    <option value="sun">Sunday</option>
                                    <option value="mon">Monday</option>
                                    <option value="tue">tuesday</option>
                                    <option value="wed">Wednesday</option>
                                    <option value="thu">Thursday</option>
                                    <option value="fri">Friday</option>
                                </select>
                            </div>
                            <div class="form-group col-md-4" id="monthly_time" style="display:none;">
                                <label>Monthly Time</label>
                                <select name="monthly_time" class="form-control form-control-lg">
                                    <option value="1">1st day Month</option>
                                    <option value="15">15th day of Month</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="form-group col-md-12 text-center">
                            <button type="submit" class="btn btn-block btn-success mr-2">Update</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="row justify-content-center">

        <div class="col-md-12">
            <div class="card mt-3">
                <div class="card-header bg-primary">
                    <h4 class="card-title font-weight-normal">Cron Job Setting Instruction</h4>
                </div>
                    <div class="card-body">

                        @csrf
                        <div class="row justify-content-between mb-5">


                            <div class="col-md-12">
                              <p style="font-size: 30px; ">  To automate BV Matching Bonus, choose your required setting from above and run the <code style="display: inline-block;"> cron job </code> on your server.
                                Set the Cron time as minimum as possible. Once per <code style="display: inline-block;"> 5-15 </code> minutes is ideal.</p>
                            </div>

                            <div class="col-md-8">
                            <label>Cron Command</label>
                                <div class="input-group custom-height">
                                    <input id="ref" type="text" class="form-control" value="curl -s {{route('bv.matching.cron')}}"
                                           name="total_bv" readonly="">
                                    <div class="input-group-append" id="copybtn">
                                        <span class="input-group-text btn-success" id="copybtn" data-copytarget="#ref"  > COPY</span>
                                    </div>
                                </div>
                            </div>

{{--                            <button id="copybtn" data-copytarget="#ref" type="button"><i id="copybtn" data-copytarget="#ref" class="fa fa-copy"></i></button>--}}





                                 <div class="col-md-4">
                                        <div class="dashboard-w1
                                        @if(Carbon\Carbon::parse($general->last_cron)->diffInSeconds()<600)
                                         bg-success
                                        @elseif(Carbon\Carbon::parse($general->last_cron)->diffInSeconds()<1200)
                                         bg-warning
                                         @else
                                         bg-danger
                                        @endif
                                         border-radius-10">
                                      <div class="icon">
                                        <i class="fa fa-shopping-cart"></i>
                                      </div>
                                      <div class="details">
                                        <div class="desciption">
                                          <span>Last Cron Run</span>
                                        </div>
                                        <div class="numbers">
                                          <span class="amount">{{Carbon\Carbon::parse($general->last_cron)->difFforHumans()}}</span>
                                        </div>
                                      </div>
                                    </div>

                            </div>

                        </div>
                    </div>

            </div>
        </div>
    </div>







@endsection

@push('style')
    <style>
        .custom-height .form-control {
            height: 70px !important;
            font-size: 50px;
            line-height: 70px;
            text-align: center;
            font-weight: 700;
        }
    </style>



@endpush

@push('script')
    <script>
        $("select[name=cary_flash]").val("{{ $general->cary_flash}}");
        $("select[name=matching_bonus_time]").val("{{ $general->matching_bonus_time}}");
        $("select[name=weekly_time]").val("{{ $general->matching_when}}");
        $("select[name=monthly_time]").val("{{ $general->matching_when}}");
        $("select[name=daily_time]").val("{{ $general->matching_when}}");


        $('select[name=matching_bonus_time]').on('change', function() {
            var matching_bonus_time = $(this).val();
            console.log(matching_bonus_time);
            if(matching_bonus_time == 'daily')
            {

                document.getElementById('weekly_time').style.display = 'none';
                document.getElementById('monthly_time').style.display = 'none'
                document.getElementById('daily_time').style.display = 'block'

            }
            else if(matching_bonus_time == 'weekly')
            {


                document.getElementById('weekly_time').style.display = 'block';
                document.getElementById('monthly_time').style.display = 'none'
                document.getElementById('daily_time').style.display = 'none'
            }
            else if(matching_bonus_time == 'monthly')
            {


                document.getElementById('weekly_time').style.display = 'none';
                document.getElementById('monthly_time').style.display = 'block'
                document.getElementById('daily_time').style.display = 'none'
            }
        }).change();




        (function() {

            'use strict';

            // click events
            document.body.addEventListener('click', copy, true);

            // event handler
            function copy(e) {


                // find target element
                var
                    t = e.target,
                    c = t.dataset.copytarget,
                    inp = (c ? document.querySelector(c) : null);

                // is element selectable?
                if (inp && inp.select) {

                    // select text
                    inp.select();

                    try {
                        // copy text
                        document.execCommand('copy');
                        inp.blur();

                        // copied animation
                        t.classList.add('copied');
                        setTimeout(function() { t.classList.remove('copied'); }, 1500);
                    }
                    catch (err) {
                        alert('please press Ctrl/Cmd+C to copy');
                    }

                }

            }

        })();

    </script>






@endpush


