@extends(activeTemplate() .'layouts.master')

@section('content')

    @include(activeTemplate() .'partials.front_br')



    <section class="blog-area section-padding-2 gradient-overlay poly-particle">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12">
                    <div class="blog-details">
                        <img class="mb-0" src="{{ get_image(config('constants.frontend.blog.post.path') .'/'. $blog->value->image) }}" alt="">

                    </div>
                    <div class="blog-details custom-padding-30">
                    <div class="blog-meta">
                            <span><a href=""><i class="flaticon-calendar"></i> {{\Carbon\Carbon::parse($blog->created_at)->diffForHumans()}}</a></span>

                        </div>
                        <h2> @lang($blog->value->title)</h2>

                        <p>
                            @php echo $blog->value->body; @endphp
                        </p>
                    </div>
                    <div class="post-share-and-tag row justify-content-end">

                        <div class="col-xl-5 col-lg-5 col-md-6">
                            <div class="social">
                                <a  ><i class="fa fa-share-alt"></i> </a>
                                <a href="https://www.facebook.com/sharer/sharer.php?u={{urlencode(url()->current()) }}" class="cl-facebook"><i class="fab fa-facebook"></i></a>
                                <a href="https://twitter.com/intent/tweet?text=my share text&amp;url={{urlencode(url()->current()) }}" class="cl-twitter"><i class="fab fa-twitter"></i></a>
                                <a href="http://pinterest.com/pin/create/button/?url={{urlencode(url()->current()) }}" class="cl-pinterest"><i class="fab fa-pinterest"></i></a>
                                <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url={{urlencode(url()->current()) }}&amp;title=my share text&amp;summary=dit is de linkedin summary" class="cl-linkedin"><i class="fab fa-linkedin"></i></a>

                            </div>
                        </div>
                    </div>


                </div>
                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6">
                    <div class="site-sidebar">


                        <div class="single-sidebar bg-white" >
                            <h3>Recent News</h3>
                            @foreach($latestBlogs as $data)



                                <div class="single-sidebar-news">
                                    <div class="sidebar-news-thumb">
                                        <img src="{{ get_image(config('constants.frontend.blog.post.path') .'/thumb_'. $data->value->image) }}" alt="">
                                    </div>
                                    <div class="sidebar-news-content">
                                        <h5><a href="{{ route('singleBlog', [slug($data->value->title) , $data->id]) }}">{{__($data->value->title)}}</a></h5>
                                        <p>Post by <a >@lang('Admin')</a>{{\Carbon\Carbon::parse($data->created_at)->diffForHumans()}}</p>
                                    </div>
                                </div>

                            @endforeach




                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>



@stop
