@extends(activeTemplate().'layouts.user-master')
@push('style-lib')
    <link rel="stylesheet" href="{{asset(activeTemplate(true) .'build/css/intlTelInput.css')}}">
    <style>
        .intl-tel-input {
            width: 100%;
        }


    </style>
@endpush
@section('panel')
    <div class="signin-section pt-5">
        <div class="container-fluid">
            <div class="row justify-content-center align-items-center">
                <div class="col-md-6 col-sm-12">
                    <div class="login-area registration-form-area">
                        <div class="login-header-wrapper text-center">
                            <a href="{{url('/')}}"> <img class="logo"
                                                         src="{{ get_image(config('constants.logoIcon.path') .'/logo.png') }}"
                                                         alt="image"> </a>
                            <p class="text-center admin-brand-text">@lang('user sign up')</p>
                        </div>
                        <form action="{{ route('user.register') }}" method="POST" class="login-form" id="recaptchaForm">
                            @csrf
                            <div class="login-inner-block">

                                <div class="form-row">


                                    <div class="frm-grp form-group col-md-6 ">

                                        <label>@lang('Referral')</label>
                                        <input type="text" class="referral" id="ref_name" value="{{old('referral')}}"
                                               placeholder="@lang('Enter Referral Username')"
                                               name="referral" required>

                                        <span id="referral"></span>

                                        <div id="ref">

                                        </div>
                                    </div>


                                    <div class="frm-grp form-group col-md-6 ">

                                        <label>@lang('Position')</label>
                                        <select name="position" class="position" id="position" required
                                                disabled="disabled">
                                            <option value="">@lang('SELECT POSITION')</option>
                                            @foreach(config('constants.mlm.positions') as $k=> $v)
                                                <option value="{{$k}}">@lang($v)</option>
                                            @endforeach


                                        </select>

                                        <span id="position-test"><span class="text-danger">@lang('Please choose referral username first')</span></span>


                                    </div>


                                    <div class="frm-grp form-group col-md-6">

                                        <label>@lang('Your first name')</label>
                                        <input type="text" value="{{old('firstname')}}"
                                               placeholder="@lang('Enter your first name')"
                                               name="firstname" required>
                                    </div>

                                    <div class="frm-grp form-group col-md-6">

                                        <label>@lang('Your last name')</label>
                                        <input type="text" value="{{old('lastname')}}"
                                               placeholder="@lang('Enter your last name')"
                                               name="lastname" required>
                                    </div>


                                    <div class="frm-grp form-group col-md-6">
                                        <label>@lang('Your email')</label>
                                        <input type="text" value="{{old('email')}}"
                                               placeholder="@lang('Enter your email')"
                                               name="email" required>
                                    </div>

                                    <div class="frm-grp form-group col-md-6">
                                        <label>@lang('Your mobile')</label>
                                        <input type="text" value="{{old('mobile')}}"
                                               placeholder="@lang('Enter your mobile number')"
                                               name="mobile" required>
                                    </div>
                                    <div class="frm-grp form-group col-md-6">
                                        <label>@lang('Your Country')</label>

                                        <select class="frm-grp" name="country" required>
                                            <option value="">@lang('Select country')</option>
                                            @include('partials.country')

                                        </select>
                                    </div>


                                    <div class="frm-grp form-group col-md-6">
                                        <label>@lang('Your city')</label>
                                        <input type="text" value="{{old('city')}}"
                                               placeholder="@lang('Enter your city')"
                                               name="city" required>
                                    </div>

                                    <div class="frm-grp form-group col-md-6">
                                        <label>@lang('Your state')</label>
                                        <input type="text" value="{{old('state')}}"
                                               placeholder="@lang('Enter your state')"
                                               name="state" required>
                                    </div>
                                    <div class="frm-grp form-group col-md-6">
                                        <label>@lang('Your zip code')</label>
                                        <input type="text" value="{{old('zip')}}"
                                               placeholder="@lang('Enter your zip')"
                                               name="zip" required>
                                    </div>

                                    <div class="frm-grp form-group col-md-12">
                                        <label>@lang('Your Username')</label>
                                        <input type="text" name="username" value="{{ old('username') }}"
                                               placeholder="@lang('Enter your username')" required>
                                    </div>

                                    <div class="frm-grp form-group col-md-6">
                                        <label>@lang('Password')</label>
                                        <input type="password" name="password"
                                               placeholder="@lang('Enter your password')" required>
                                    </div>
                                    <div class="frm-grp form-group col-md-6">
                                        <label>@lang('Confirm Password')</label>
                                        <input type="password" name="password_confirmation"
                                               placeholder="@lang('Confirm your password')" required>
                                    </div>
                                </div>
                            </div>

                            <div class="btn-area text-center">
                                <button type="submit" id="recaptcha" class="submit-btn">@lang('Sign Up')</button>
                            </div>
                            <br>

                            <div class="d-flex mt-3 justify-content-end">

                                <a href="{{route('user.login')}}"
                                   class="forget-pass">@lang('Already have a account?')</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection

@push('style-lib')
    <link rel="stylesheet" href="{{asset(activeTemplate(true) .'users/css/signin.css')}}">
    <style>
        .registration-form-area .frm-grp + .frm-grp {
            margin-top: 0;
        }

        .registration-form-area .frm-grp label {
            color: #98a6ad !important;
            font-weight: 400;
        }

        .registration-form-area select {
            border: 1px solid #5220c5;
            width: 100%;
            padding: 12px 20px;
            color: #ffffff;;
            z-index: 9;
            background-color: #3c139c;
            border-radius: 3px;
        }

        .registration-form-area select option {
            color: #ffffff;
        }
    </style>
@endpush


@push('js')



    <script>
        $(document).ready(function () {
            var not_select_msg = $('#position-test').html();

            $(document).on('keyup', '#ref_name', function () {
                var ref_id = $('#ref_name').val();
                var token = "{{csrf_token()}}";


                $.ajax({
                    type: "POST",
                    url: "{{route('check.referral')}}",
                    data: {
                        'ref_id': ref_id,
                        '_token': token
                    },
                    success: function (data) {
                        if (data.success) {
                            $('select[name=position]').removeAttr('disabled');
                            $('#position-test').text('');
                        } else {
                            $('select[name=position]').attr('disabled', true);
                            $('#position-test').html(not_select_msg);
                        }
                        $("#ref").html(data.msg);


                    }
                });
            });


            $(document).on('change', '#position', function () {
                updateHand();
            });

            function updateHand() {
                var pos = $('#position').val();
                var referrer_id = $('#referrer_id').val();
                var token = "{{csrf_token()}}";
                $.ajax({
                    type: "POST",
                    url: "{{route('get.user.position')}}",
                    data: {
                        'referrer': referrer_id,
                        'position': pos,

                        '_token': token
                    },
                    success: function (data) {

                        console.log(data);

                        $("#position-test").html(data.msg);
                    }
                });
            }
        });
    </script>


    <script>
        $("select[name=country]").val("{{ old('country') }}");
    </script>


@endpush
