@extends(activeTemplate() .'layouts.app')

@section('content')

    <div class="row justify-content-center">
        <div class="col-md-8">

            <div class="row justify-content-center">
                <div class="col-md-5">
                    <div class="card">
                        <div class="card-body text-center border-bottom">
                            <img src="{{ get_image(config('constants.user.profile.path') .'/'. Auth::user()->image) }}"
                                 alt="profile-image" class="user-image">
                            <h5 class="card-title mt-3">{{ Auth::user()->name }}</h5>
                        </div>
                        <div class="card-body">
                            <p class="clearfix">
                                <span class="float-left">@lang('Username')</span>
                                <span class="float-right font-weight-bold"><a class="">{{ Auth::user()->username }}</a></span>
                            </p>
                            <p class="clearfix">
                                <span class="float-left">@lang('E-mail')</span>
                                <span class="float-right text-muted">{{ Auth::user()->email }}</span>
                            </p>
                            <p class="clearfix">
                                <span class="float-left">@lang('Phone')</span>
                                <span class="float-right text-muted">{{ Auth::user()->mobile ?: 'Not available'}}</span>
                            </p>
                            <p class="clearfix">
                                <span class="float-left">@lang('Balance')</span>
                                <span
                                    class="float-right text-muted">{{ $general->cur_sym }}{{ formatter_money(Auth::user()->balance) }}</span>
                            </p>
                            <p class="clearfix">
                                <span class="float-left">@lang('Status')</span>
                                <span class="float-right text-muted">
                            <span class="badge badge-pill badge-success">@lang('Active')</span>
                    </span>
                            </p></div>
                    </div>

                </div>

            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-lg-12">

            <div class="card">
                <div class="table-responsive table-responsive">
                    <table class="table align-items-center table-light">
                        <thead>
                        <tr>

                            <th scope="col">@lang('Paid left') </th>
                            <th scope="col">@lang('Paid right') </th>
                            <th scope="col">@lang('Free left') </th>
                            <th scope="col">@lang('Free right') </th>
                            <th scope="col">@lang('Bv left') </th>
                            <th scope="col">@lang('Bv right') </th>
                        </tr>
                        </thead>
                        <tbody class="list">
                        <tr>
                            <td>{{$logs->paid_left}}</td>
                            <td>{{$logs->paid_right}}</td>
                            <td>{{$logs->free_left}}</td>
                            <td>{{$logs->free_right}}</td>
                            <td>{{formatter_money($logs->bv_left)}}</td>
                            <td>{{formatter_money($logs->bv_right)}}</td>
                        </tr>

                        </tbody>


                    </table>
                </div>
                <div class="card-footer py-4">
                    <nav aria-label="...">


                    </nav>
                </div>
            </div>
        </div>
    </div>


@endsection

@push('style')
    <style>
        .user-image {
            width: 200px;
            height: 200px;
        }
    </style>

    <script>
        $("select[name=country]").val("{{ Auth::user()->address->country }}");
    </script>
@endpush

