<?php

namespace App\Http\Controllers\Auth;

use App\GeneralSetting;
use App\User;
use App\Http\Controllers\Controller;
use App\UserExtra;
use App\WithdrawMethod;
use Illuminate\Http\Request;

use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function __construct()
    {
        $this->middleware(['guest']);
        $this->middleware('regStatus')->except('registrationNotAllowed');
    }

    public function showRegistrationForm($ref = null)
    {
        $page_title = "Sign Up";
        return view(activeTemplate() . 'user.auth.register', compact('page_title'));
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'referral' => 'required|string|max:60',
            'position' => 'required|string|max:60',
            'firstname' => 'required|string|max:60',
            'lastname' => 'required|string|max:60',
            'country' => 'required|string|max:80',
            'state' => 'required|string|max:80',
            'zip' => 'required|string|max:80',
            'city' => 'required|string|max:80',
            'email' => 'required|string|email|max:160|unique:users',
            'mobile' => 'required|string|max:30|unique:users',
            'password' => 'required|string|min:6|confirmed',
            'username' => 'required|string|unique:users|min:6',
        ]);




    }




    protected function create(array $data)
    {
        $gnl = GeneralSetting::first();

        $userCheck = User::where('username', $data['referral'])->first();

        if ($userCheck == NULL)
        {
            $notify[] = ['error', 'Referral not found.'];
            return back()->withNotify($notify);
        }else{

            $pos = getPosition($userCheck->id, $data['position']);

            $ref_id = $userCheck->id;
            $pos_id = $pos['pos_id'];
            $position = $pos['position'];
        }


        return User::create([
            'ref_id' => $ref_id,
            'pos_id' => $pos_id,
            'position' => $position,
            'firstname' => $data['firstname'],
            'lastname' => $data['lastname'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
            'username' => $data['username'],
            'mobile' => $data['mobile'],
            'address' => [
                'address' =>  '',
                'state' => $data['state'],
                'zip' => $data['zip'],
                'country' => $data['country'],
                'city' =>  $data['city'],
            ],
            'status' => 1,
            'ev' =>  $gnl->ev ? 0 : 1,
            'sv' =>  $gnl->sv ? 0 : 1,
            'ts' => 0,
            'tv' => 1,
        ]);
    }

    public function registered(Request $request, $user)
    {

        $user_extras = new UserExtra();
        $user_extras->user_id = $user->id;
        $user_extras->save();


        updateFreeCount($user->id);

        return redirect()->route('user.home');
    }



}
