@extends(activeTemplate() .'layouts.master')

@section('content')

    @include(activeTemplate() .'partials.front_br')


    <section class="blog-area section-padding-2 gradient-overlay poly-particle ">
        <div class="container">

            <div class="row justify-content-center">


                @foreach($blogs as $blog)
                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 wow fadeInUp" data-wow-delay="0.4s">
                        <div class="single-blog-2">
                            <div class="single-blog-img">
                                <img src="{{ get_image(config('constants.frontend.blog.post.path') .'/'. $blog->value->image) }}" alt="">
                                <a href="{{ route('singleBlog', [slug($blog->value->title) , $blog->id]) }}"><i class="flaticon-add"></i></a>
                            </div>
                            <div class="single-blog-content">
                                <div class="blog-meta">
                                    <span><a href=""><i class="flaticon-calendar"></i>{{\Carbon\Carbon::parse($blog->created_at)->diffForHumans()}}</a></span>

                                </div>
                                <h3><a href="{{ route('singleBlog', [slug($blog->value->title) , $blog->id]) }}">@lang($blog->value->title)</a></h3>
                                <p>{{ \Illuminate\Support\Str::limit(strip_tags($blog->value->body), 160, '...') }}</p>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>

            <div class="row justify-content-center d-block">
                <div class="col-md-12">

                    {{$blogs->links()}}

                </div>

            </div>

        </div>
    </section>




@stop