<!DOCTYPE html>
<html lang="en">
<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="shortcut icon" href="{{ asset(config('constants.logoIcon.path') .'/favicon.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset(config('constants.logoIcon.path') .'/favicon.png') }}" type="image/x-icon">
    <title>{{ $general->sitename(__($page_title)) }}</title>
    <!-- Bootstrap -->
    <link href="{{asset(activeTemplate(true) .'front/css/bootstrap.min.css')}}" rel="stylesheet">
    <link href="{{asset(activeTemplate(true) .'front/css/font-awesome.min.css')}}" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.11.2/css/all.css"/>
    <link href="{{asset(activeTemplate(true) .'front/css/owl.carousel.min.css')}}" rel="stylesheet">
    <link href="{{asset(activeTemplate(true) .'front/css/themify-icons.css')}}" rel="stylesheet">
    <link href="{{asset(activeTemplate(true) .'front/css/nice-select.css')}}" rel="stylesheet">
    <link href="{{asset(activeTemplate(true) .'front/css/magnific-popup.css')}}" rel="stylesheet">
    <!-- Main css -->
    <link href="{{asset(activeTemplate(true) .'front/css/main.css')}}" rel="stylesheet">
    @include('partials.seo')
    @yield('css')
    @stack('css')
    <link rel="stylesheet"
          href='{{ asset(activeTemplate(true) . "front/css/color.php?color=$general->bclr")}}'>

</head>
<body>

<header class="header-area">
    <nav class="navbar navbar-expand-lg main-menu">
        <div class="container-fluid">

            <a class="navbar-brand" href="{{url('/')}}"><img
                        src="{{get_image(config('constants.logoIcon.path') .'/logo.png')}}"
                        class="d-inline-block align-top" alt=""></a>

            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
                    aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="menu-toggle"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav m-auto">
                    <li class="nav-item"><a class="nav-link" href="{{url('/')}}">@lang('Home')</a></li>
                    <li class="nav-item"><a class="nav-link" href="{{route('about')}}">@lang('About')</a></li>
                    <li class="nav-item"><a class="nav-link" href="{{route('marketing')}}">@lang('Marketing Tool')</a></li>

                    <li class="nav-item"><a class="nav-link" href="{{route('blog')}}">@lang('Blog')</a></li>
                    <li class="nav-item"><a class="nav-link" href="{{route('faq')}}">@lang('Faq')</a></li>
                    <li class="nav-item"><a class="nav-link" href="{{route('contact')}}">@lang('Contact')</a></li>
                </ul>

                <select id="langSel" >
                    <option style="color: black" value="en">@lang('English')</option>
                    @foreach($lang as $data)
                        <option value="{{strtolower($data->code)}}"
                                @if(Session::get('lang') == strtolower($data->code)) selected="selected"
                                @endif style="color: black"><img
                                    src="{{ asset('assets/image/lang/'.$data->icon)}}"> {{strtoupper($data->name)}}
                        </option>
                    @endforeach
                </select>

                <div class="header-btn justify-content-end">
                    <a href="{{route('user.login')}}" class="bttn-small btn-emt">@lang('Account')</a>
                </div>
            </div>
        </div>
    </nav>
</header><!--/Header Area-->

@yield('content')


<footer class="footer-area section-padding-2 blue-bg wave-animation">
    <div class="container">

        <div class="row mb-40 justify-content-center">

            <div class="col-xl-6 col-lg-8 col-md-8 col-sm-12">
                <div class="footer-widget text-center">
                    <a href=""><img src="{{get_image(config('constants.logoIcon.path') .'/logo.png')}}" alt=""></a>
                    <p>{{__($footer->subtitle)}}</p>
                    <div class="social">
                        @foreach($social as $item)
                            <a href="{{$item->value->url}}"
                               title="{{$item->value->title}}">@php echo $item->value->icon; @endphp</a>
                        @endforeach

                    </div>
                </div>
            </div>

            <div class="col-xl-12 centered cl-white copyright mt-50">
                <p class="mb-0">{{__($footer->title)}}</p>
            </div>
        </div>
    </div>
</footer>


<!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
<script src="{{asset(activeTemplate(true) .'front/js/jquery-3.2.1.min.js')}}"></script>
<script src="{{asset(activeTemplate(true) .'front/js/jquery-migrate.js')}}"></script>

<script src="{{asset(activeTemplate(true) .'front/js/popper.js')}}"></script>
<script src="{{asset(activeTemplate(true) .'front/js/bootstrap.min.js')}}"></script>
<script src="{{asset(activeTemplate(true) .'front/js/owl.carousel.min.js')}}"></script>
<script src="{{asset(activeTemplate(true) .'front/js/parallax.min.js')}}"></script>

<script src="{{asset(activeTemplate(true) .'front/js/waypoints.min.js')}}"></script>
<script src="{{asset(activeTemplate(true) .'front/js/jquery.counterup.min.js')}}"></script>
<script src="{{asset(activeTemplate(true) .'front/js/scrollUp.min.js')}}"></script>

<script src="{{asset(activeTemplate(true) .'front/js/particles.min.js')}}"></script>
<script src="{{asset(activeTemplate(true) .'front/js/particle-app.js')}}"></script>
<script src="{{asset(activeTemplate(true) .'front/js/jquery.nice-select.min.js')}}"></script>
<script src="{{asset(activeTemplate(true) .'front/js/magnific-popup.min.js')}}"></script>


<script src="{{asset(activeTemplate(true) .'front/js/script.js')}}"></script>


@include('partials.notify')

@stack('js')

<script>
    $(document).on('change', '#langSel', function () {
        var code = $(this).val();
        window.location.href = "{{url('/')}}/change-lang/" + code;
    });
</script>
</body>


</html>
