@extends(activeTemplate() .'layouts.app')
@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="table-responsive table-responsive-xl">
                    <table class="table align-items-center table-light">
                        <thead>
                        <tr>
                            <th scope="col">@lang('Date')</th>
                            <th scope="col">@lang('TRX')</th>
                            <th scope="col">@lang('Method')</th>
                            <th scope="col">@lang('Amount')</th>
                            <th scope="col">@lang('Status')</th>
                        </tr>
                        </thead>
                        <tbody >

                        @forelse($logs as $item)
                            <tr>
                                <td>{{ show_datetime($item->create_at) }}</td>
                                <td>{{ $item->trx }}</td>
                                <td>{{ __($item->gateway->name) }}</td>
                                <td>{{ $general->cur_sym }}{{ formatter_money($item->amount) }} </td>
                                <td>
                                    @if($item->method_code >= 1000 && $item->status == 0)
                                        <span class="badge badge-warning">@lang('Pending')</span>
                                    @else
                                        <span class="badge badge-success">@lang('Complete')</span>
                                    @endif

                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="100%">{{ __($empty_message) }}</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="card-footer py-4">
                    <nav aria-label="...">
                        {{ $logs->links() }}
                    </nav>
                </div>

            </div>
        </div>
    </div>
@endsection



